angular.module('ngRestApp').controller('connectionsCtrl' , function($scope,$http)   {
	var controller = $scope;
	controller.i18n = i18n.connections;

	$(".mayselect").removeClass("selected");
	$("#connections").addClass("selected");


	controller.createConnection = function(newConnectionName){
		if(typeof newConnectionName == 'undefined' || newConnectionName.trim() == ""){
			return false;
		}
		if (controller.connections.find(x=> x.connectionName == newConnectionName)) {
			alert (controller.i18n.exist);
			return false;
		}

		var hostObj = {Connection:[]};

		var connectionObj = {
			connectionName : newConnectionName.trim(),
			alHosts : [hostObj]
		}

		var data = {Connections : connectionObj};

		controller.connections.unshift(data.Connections);
		controller.newConnectionName = "";

	}

	controller.addNewHost = function(connectionName){
		var connectionToUse = {};
		for(var i = 0; i < controller.connections.length; i++){
			if(controller.connections[i].connectionName === connectionName){
				connectionToUse = controller.connections[i];
				break;
			}
		}
		if(connectionToUse.alHosts[0].hasOwnProperty("Connection")){
			connectionToUse.alHosts[0].Connection.push({Host : "", Port: ""});
		}else{
			connectionToUse.alHosts[0] = {Connection:[]};
			connectionToUse.alHosts[0].Connection.push({Host : "", Port: ""});
		}
	}

	controller.deleteHost = function(connectionName, index){
		var connectionToUse = {};
		for(var i = 0; i < controller.connections.length; i++){
			if(controller.connections[i].connectionName === connectionName){
				connectionToUse = controller.connections[i];
				break;
			}
		}
		connectionToUse.alHosts[0].Connection.splice(index,1);
	}

	controller.saveConnection = function(connection) {
		console.log(connection);
		if(!connection.alHosts[0].hasOwnProperty("Connection") || connection.alHosts[0].Connection.length == 0){
			alert(controller.i18n.emptyhost);
			return false;
		}

		for(var i = 0; i < connection.alHosts[0].Connection.length; i++){
			if(connection.alHosts[0].Connection[i].Host === "" || connection.alHosts[0].Connection[i].Port === ""){
				alert(controller.i18n.emptyfield);
				return false;
			}
		}
		var data = {Connections : connection};
		$http.put('../connections',data).then(function() {
			alert(controller.i18n.saved);
			controller.reload();
		})
	}
	
	controller.deleteConnection = function(connectionName) {
		var ans = confirm(controller.i18n.confirmdelete);
		if (!ans == true) {
			return false;
		}
		$http.delete('../connections/' + connectionName).then(function() {
			//controller.connections.splice(index,1);
			alert(controller.i18n.deleted);
			controller.reload();
		})
		
	}

	controller.reload = function() {
		$http.get('../connections')
	    .then(function(res){
			var connections = [];

			if(!res.data.list[0].hasOwnProperty('Connections')){
				controller.connections = connections;
				return false;
			}

			if(Array.isArray(res.data.list[0].Connections)){
				connections = res.data.list[0].Connections.slice().reverse();
			}else{
				connections = [res.data.list[0].Connections];
			}

			for(var i = 0; i < connections.length; i++){

				if(!Array.isArray(connections[i].alHosts[0].Connection)){
					connections[i].alHosts[0].Connection = [connections[i].alHosts[0].Connection];
				}
			}

			controller.connections = connections;
	     });
	}
	controller.reload();

});