function addAttrToAttributes(obj, keyAttribute, extraAttribute){
	if (obj.oSearch && obj.oSearch.ReadAttributes) {
		var o = obj.oSearch.ReadAttributes;
		for (var i=0; i < o.size(); i++) {
			var attr = o.get(i);
			if (attr.equalsIgnoreCase(keyAttribute)) {
				debug ("Found attribute: " + keyAttribute);
				o.add(extraAttribute);
				debug ("Add attribute: " + extraAttribute + " to ReadAttributes set");
			}
		}
	}
	return obj;
}

function transformInputField(obj){
    var fieldName = "SearchFilter";
    var src = "\\";
    var replacement = "\\5c";
    debug (fieldName + " - " + src + " : " + replacement);
    if (isOperation(obj,"search")) {
    	if (typeof obj.oSearch[fieldName] !== 'undefined') {
	    var str = obj.oSearch[fieldName];
	    debug("Original: " + str);
	    str = str.replace(src, replacement);
	    obj.oSearch[fieldName] = str;
	    debug("Transformed: " + obj.oSearch[fieldName]);
	} else {
	    debug("No field found: " + fieldName);
	}

    }
    return obj;
}

function addAttrIfRequested (obj, attrToCheck, attrToAdd){
	debug("------------------------");
	debug("addAttrIfRequested : " + attrToCheck + " : " + attrToAdd);
	if (isOperation(obj,"search")) {
		var readAttrArray= obj.oSearch.ReadAttributes;
		debug("Found attributes:" + readAttrArray.size());
		for (var i=0; i < readAttrArray.size(); i++) {
			debug("Proceed instance " + i + " Check is field \"" + attrToCheck + "\" present: " + readAttrArray.get(i));
			var isPresent = false;
			if (readAttrArray.get(i).toLowerCase() == attrToCheck.toLowerCase()){
				isPresent = true;
				debug ("Found \"" + attrToCheck + "\" in ReadAttributes list");
				break;
			}
		}
		if (isPresent) {
			readAttrArray.add(attrToAdd)
			debug ("Add \"" + attrToAdd + "\" to ReadAttributes list");
			};
	}
	return obj;
}

function returnAttrIfExtraAttrValid(obj, mainAttr, extraAttr, removeExtra){
	debug("------------------------");
	debug("returnAttrIfExtraAttrValid : " + mainAttr + " : " + extraAttr);
	debug("Found instances:" + obj.alInstances.size());
	 for (var i=0; i < obj.alInstances.size(); i++) {
			debug("Proceed instance " + i +" Check is field " + extraAttr + " present");
			var isMainPresent = false;
			var isExtraPresent = false;
			if (obj.alInstances.get(i).values.containsKey(mainAttr.toLowerCase())) {
				debug("mainAttr \"" + mainAttr +"\" present");
				isMainPresent = true; 
			}
			if (obj.alInstances.get(i).values.containsKey(extraAttr.toLowerCase())){
				debug("extraAttr \"" + extraAttr +"\" present");
				isExtraPresent = true;
			}
			
			 if (isExtraPresent){
				 debug("extraAttr attrs are present");
				    var values = obj.alInstances.get(i).values;
				    debug ("Remove field " + extraAttr +" from result");
			    	var it=values.keySet().iterator();
					while (it.hasNext())
					{
					 var entry = it.next();
					 if (entry.equals(extraAttr.toLowerCase())) {if (removeExtra) it.remove();}
					}
			 } else {
				 debug("extraAttr attrs not present");
				    var values = obj.alInstances.get(i).values;
				    debug ("Remove field " + mainAttr +" from result");
			    	var it=values.keySet().iterator();
					while (it.hasNext())
					{
					 var entry = it.next();
					 if (entry.equals(mainAttr.toLowerCase())) it.remove();
					}
				 
			 } 
	 }	
	
	return obj;
}


function removeExtraAttrFromResult(obj, mainAttr, extraAttr, isReplaceValue){
	debug("------------------------");
	debug("removeAttrFromResult : " + mainAttr + " : " + extraAttr + " : " + isReplaceValue);
	debug("Found instances:" + obj.alInstances.size());
	 for (var i=0; i < obj.alInstances.size(); i++) {
			debug("Proceed instance " + i +" Check is field " + extraAttr + " present");
			var isMainPresent = false;
			var isExtraPresent = false;
			if (obj.alInstances.get(i).values.containsKey(mainAttr.toLowerCase())) {
				debug("mainAttr \"" + mainAttr +"\" present");
				isMainPresent = true; 
			}
			if (obj.alInstances.get(i).values.containsKey(extraAttr.toLowerCase())){
				debug("extraAttr \"" + extraAttr +"\" present");
				isExtraPresent = true;
			}
			
			 if (isMainPresent && isExtraPresent){
				 debug("Both attrs are present");
				 if (isReplaceValue){
					 var valueSave = obj.alInstances.get(i).values.get(extraAttr.toLowerCase());
					 debug ("Replace value for \""+mainAttr+"\" with value from \""+ extraAttr + "\" : " + valueSave);
					 obj.alInstances.get(i).values.put(mainAttr.toLowerCase(), valueSave);
				 }
				    var values = obj.alInstances.get(i).values;
				    debug ("Remove field " + extraAttr +" from result");
			    	var it=values.keySet().iterator();
					while (it.hasNext())
					{
					 var entry = it.next();
					 if (entry.equals(extraAttr.toLowerCase())) it.remove();
					}
			 }
	 }
	 return obj;
}

function getWithBackQuery(obj, attrForBackQuery, delimeter, request, restletData, executedRequest){
	debug("------------------------");
	debug("getWithBackQuery");
	if (executedRequest.oSearch) {
		debug("oSearch");
		var isBackQueryAttr = false;
		var managerDn;
		var readAttrArray= executedRequest.oSearch.ReadAttributes;
		debug("Found attributes:" + readAttrArray.size());
		for (var i=0; i < readAttrArray.size(); i++) {
			if (readAttrArray.get(i).toLowerCase() == attrForBackQuery.toLowerCase()) {
				isBackQueryAttr=true;
			}
			if ( readAttrArray.get(i).indexOf(delimeter) == 0) {
				request.oSearch.ReadAttributes.add(readAttrArray.get(i).substring(1, readAttrArray.get(i).length()));
			};			
		}
		if (isBackQueryAttr) {
		  debug("Found instances:" + obj.alInstances.size())
		  request.oSearch.ReadAttributes.add("employeestatus");
		  for (var i=0; i < obj.alInstances.size(); i++) {
			if (obj.alInstances.get(i).values.containsKey(attrForBackQuery.toLowerCase())){
				debug("found \"" + attrForBackQuery.toLowerCase() + "\" value for instance: " + i);
				var dns = obj.alInstances.get(i).values.get(attrForBackQuery.toLowerCase());
				debug (dns);
					for (var j=0; j < dns.size(); j++) {
						debug("!!!Back request for: " + dns.get(j));
						request.oSearch.dn = dns.get(j);
						request.oSearch.Scope = "S";
						//debug(request.oSearch.ReadAttributes);
						var res = request.doSearchRequest(restletData, request);
						debug("-----res-------");
					    debug("Got instances backRequest: " + res.alInstances.size())
					    	for (var k=0; k < res.alInstances.size(); k++) {
					    		debug("Proceed backRequest instance: " + k);
					    		debug(res.alInstances.get(k).values);
					    		if (res.alInstances.get(k).values.containsKey("employeestatus") 
					    				&& res.alInstances.get(k).values.get("employeestatus").contains("A")){
					    			debug("correct employeestatus contain A");
					    			obj.alInstances.get(i).backContent.add(res.alInstances.get(k));
					    		} else {
					    			debug("incorrect employeestatus not contain A");
					    		}

					    	}
					}
			}
		}
	  }	
	}
	return obj;
}




function transformOutputDoc(obj){
	var fieldToCheck = "bMOMailDGN";
	var fieldToRemove = "mail";
       debug("Found instances:" + obj.alInstances.size());
    for (var i=0; i < obj.alInstances.size(); i++) {
	debug("Proceed instance " + i);
	debug("Check is field " + fieldToCheck + " present");
	var isPresent = false;
	isPresent = obj.alInstances.get(i).values.containsKey(fieldToCheck)
	debug(isPresent);
	if (isPresent) {
	    debug("Value for field " + fieldToCheck + " :" + obj.alInstances.get(i).values.get(fieldToCheck));
	} else {
	    //getFields(obj.alInstances.get(i).values);
	    var values = obj.alInstances.get(i).values;
	    debug ("Remove field " + fieldToRemove +" from result");
    	    var it=values.keySet().iterator();
		while (it.hasNext())
		{
		  var entry = it.next();
		 if (entry.equals(fieldToRemove)) it.remove();
		 }

	 }
    }
    return obj;
}

function testJavaCall(obj, type, request, restletData){
	
	debug("-----"+type+"------data-------");
//	obj.flushTransformations();
	//debug(restletData);
	//getMethods(restletData);	
	if (request.oSearch) {
		debug("oSearch");
		request.oSearch.SearchFilter = "(&(cn=test002*)))";
		//request.oSearch.ReadAttributes.add("givenname");
		//request.oSearch.ReadAttributes.add("name");
	}
    debug("Found instances:" + obj.alInstances.size())
	for (var i=0; i < obj.alInstances.size(); i++) {
		debug(obj.alInstances.get(i));
		debug(obj.alInstances.get(i).values);
	}
	
	var res = request.doSearchRequest(restletData, request);
	debug("-----res-------");
    debug("Found instances custom request: " + res.alInstances.size())
    	for (var i=0; i < res.alInstances.size(); i++) {
    		debug(res.alInstances.get(i));
    		debug(res.alInstances.get(i).values);
    	}
    
//	getMethods(res);
	
	return obj;
}

function getMethods(obj) {
	
	  for (var id in obj) {
	    try {
	      debug(typeof(obj[id]) + " " + id + ": " + obj[id].toString());
	    } catch (err) {
	      debug(id + ": inaccessible");
	    }
	  }
	  
	}