function getModifySearchAttribute(obj) { return obj.oModify.SearchAtttribut;} 
function getModifySearchValue(obj) {return obj.oModify.SearchValue;}

function getService(obj) {
	if (obj.oModify) return obj.oModify.Service;
	if (obj.oCreate) return obj.oCreate.Service;
	if (obj.oDelete) return obj.oDelete.Service;
	if (obj.oRename) return obj.oRename.Service;
	if (obj.oMove) return obj.oMove.Service;
	if (obj.oSearch) return obj.oSearch.Service;
	return "";
}
/**
 * Checks if service name is b in a
 * @param {JavaObject} a
 * @param {String} b
 * @returns {Boolean}
 */
function isService(obj, value) {
	return getService(obj) == value;
}

function getOperation(obj) {
	// debug(typeof obj.oModify);
	// debug(JSON.stringify(obj.oModify));
	if (obj.oModify) return "modify";
	if (obj.oCreate) return "create";
	if (obj.oDelete) return "delete";
	if (obj.oRename) return "rename";
	if (obj.oMove) return "move";
	if (obj.oSearch) return "search";
	return "unknown";
}

/**
 * Checks if operation name is b in a
 * @param {JavaObject} a
 * @param {String} b
 * @returns {Boolean}
 */
function isOperation(obj, value) {
	return getOperation(obj) == value;
}

function getAddValues(obj) {
	var addvalues = undefined;
	if (isOperation(obj,"create")) {
		if (typeof obj.oCreate.addvalues !== 'undefined') {
			addvalues = obj.oCreate.addvalues;
		}
	}
	if (isOperation(obj,"modify")) {
		if (typeof obj.oModify.addvalues !== 'undefined') {
			addvalues = obj.oModify.addvalues;
		}
	}
	return addvalues;
}

function getRemoveValues(obj) {
	var remvalues = undefined;
	if (isOperation(obj,"modify")) {
		if (typeof obj.oModify.remvalues !== 'undefined') {
			remvalues = obj.oModify.remvalues;
		}
	}
	return remvalues;
}

function getReplaceValues(obj) {
	var repvalues = undefined;
	if (isOperation(obj,"modify")) {
		if (typeof obj.oModify.repvalues !== 'undefined') {
			repvalues = obj.oModify.repvalues;
		}
	}
	return repvalues;
}

function debug(content) { print(content + "\n"); }

function getValueKeys(values) {
	var keys = [];
	var javakeys=values.keySet().toArray(java.lang.reflect.Array.newInstance(java.lang.String,0));
	for (var i=0; i < values.keySet().size(); i++) {
		keys.push(javakeys[i]);
	}
	return keys;
}

function getValuesByKey(values, key) {
	return values.get(key);
}

/**
 * Adds value c by key b to object c
 * @param {JavaObject} a
 * @param {String} b
 * @param {String} c
 */
function addValueByKey(obj, key, value) {
	var al = new java.util.ArrayList;
	al.add(value);
	obj.oCreate.addvalues.put(key, al)
}


// TODO ADD MORE FUNCTIONS.. SETTERS AND GETTERS AND OTHER NICE STUFF TO MODIFY THE OBJECTS